; Setup source

.text
.68000

;--------------------------------------------------------------------------------- jaginit

.globl jaginit
jaginit:
; Setup GPU

	; Stop RISCs
	move.l	#0,G_CTRL
	move.l	#0,D_CTRL
	move.l	#0,G_FLAGS	; Init GPU
	move.l	#0,D_FLAGS	; Init DSP

	move.l	#$00070007,G_END	; GPU to Big Endian Mode
	move.l	#$00070007,D_END	; DSP to Big Endian Mode

	move.w	#$35cc,MEMCON2		; Big Endian Mode
	
	;move.w	#$FFFF,VI		; disable video interupts
	
.globl initvideo							
	jsr		initvideo
	
	rts

;------------------------------------------------------------------------------- InitVBint	

InitVBInt::
		move.l	#vbinterupt,LEVEL0
		
		move.w	a_vde,d0
		ori.w	#1,d0
		move.w	d0,VI
		
		
		move.w	INT1,d0			; Copy Int control reg to d0
		ori.w	#C_VIDENA,d0  	; enable VBL Interupt
		move.w	d0,INT1			; Enable the interupts
		
		move.w	sr,d0
		andi.w	#$F8FF,d0
		move.w	d0,sr
		
		rts
	
;------------------------------------------------------------------------------- initvideo	
	
initvideo:
		movem.l	d0-d6,-(sp)
		
		move.w	CONFIG,d0		; Load config ()
		andi.w	#VIDTYPE,d0		; NTSC bit set, PAL bit clear
		beq.s	palvals
		
		move.w	#NTSC_HMID,d2	; Middle of screen in pixel clocks
		move.w	#1305,d0
		
		move.w	#NTSC_VMID,d6	; Middle of screen in halflines
		move.w	#NTSC_HEIGHT,d4	; Height of screen in scanlines
		
		move.w	#29,d3		; VDB offset
				
		bra.s	calc_vals

palvals:
		move.w	#PAL_HMID,d2	; Middle of screen in pixel clocks
		move.w	#1301,d0
		
		move.w	#PAL_VMID,d6	; Middle of screen in halflines
		move.w	#PAL_HEIGHT,d4	; Height of screen in scanlines
		
		move.w	#79,d3		; VDB offset
	
calc_vals:

		move.w	d0,width
		move.w	d4,height
		
		move.w	d2,h_mid
		move.w	d6,v_mid
		
		move.w	d0,d1
		asr		#1,d1		; Width/2
		
		sub.w	d1,d2		; mid - width/2
		add.w	#4,d2		; (mid - width/2)+4
		
		
		sub.w	#1,d1		; width/2 - 1
		ori.w	#$400,d1	; (width/2 - 1)| $400
		
		move.w	d1,a_hde
		move.w	d1,HDE		; Set the Horizontal Display End
		
		move.w	d2,a_hdb
		move.w	d2,HDB1		; Set the Horizontal Display Begin
		move.w	d2,HDB2		; OP needs to only run once so both the same. (<720 pixels wide)
		
		move.w	d6,d5
		sub.w	d4,d5
		move.w	d3,a_vdb
		
		
		add.w	d4,d6
		move.w	d6,a_vde
		
		move.w	a_vdb,VDB	; Vertical Display Begin.
		move.w	#$FFFF,VDE	;REQUIRED!!!  Set the Vertical Display end  (bug requires $FFFF)
		
		clr.l	BG
		clr.l	BORD1
		
		movem.l	(sp)+,d0-d6
		rts

.GLOBL	a_hbb
a_hbb:	dc.w		0
.GLOBL	a_hbe
a_hbe:	dc.w		0

.globl	bgrnd
bgrnd:		dc.l	1
.globl	bfade
bfade:		dc.w	1

.GLOBL width
width:		dc.w	1
.GLOBL height
height:	dc.w	1
.GLOBL h_mid
h_mid:		dc.w	0
.GLOBL v_mid
v_mid:		dc.w	0
.GLOBL a_hde
a_hde:	dc.w	1
.GLOBL	a_hdb
a_hdb:	dc.w	1
.GLOBL a_vdb
a_vdb::	dc.w	1
.GLOBL a_vde
a_vde::	dc.w	1

