 ;===============================================================================================================
 ; U-235 SoundEngine
 ; Demonstration code
 ;
 ; Written by LinkoVitch 2011
 ; Copyright 2011-2014 U-235  http://www.u-235.co.uk
 ; 
 ; Please read LICENSE.TXT for licensing information
 ;===============================================================================================================

 ; This code is to illustrate how to utilize the U-235 SE within your own projects.  For further information read
 ; the included documentation manual.pdf
 
; ====================================================================================================== INCLUDES
 
.INCLUDE "jaguar.inc"
.INCLUDE "u235se.inc"

;=========================================================================================================== MAIN
 
.text
.68000

; Setup the Jag

	move.l	#INITSTACK,a7	; Setup a stack (point to the end of RAM)
	
	jsr 	jaginit				; Initialise the Jaguar (roar 64bit powah!)
	
.EXTERN bufferptr

	jsr 	InitVBInt			; Initialise the VBI - we will use this for polling the pad
	
.EXTERN dspcode
	
	;-------------------------- Copy the SoundEngine to the DSP RAM
	
	move.w	#2048,d0
	lea		dspcode,a0
	move.l	#D_RAM,a1

.loop:
	move.l	(a0)+,(a1)+
	dbra.w	d0,.loop
		
	;-------------------------------------- Setup the playback rate
	; This section is now OPTIONAL
	; if no playback rate is defined the Sound Engine will default to 16kHz
	
	move.l	#U235SE_24KHZ,U235SE_playback_rate
	move.l	#U235SE_24KHZ_PERIOD,U235SE_playback_period
		
	move.w	#C_VIDENA,INT1		; Enable the VBI 
	move.w	#$100,JOYSTICK		; enable sound

	; enable DSP
		
	move.l	#D_RAM,D_PC			; Set up D_PC (DSP's program counter)
	move.l	#RISCGO,D_CTRL		; Go, baby go!

	move.l	#module,U235SE_moduleaddr	; Point at the module to play
	jsr		modinit					; Initialize the module - populates the sample table in the mod player with sample 
									;						  info so that the player can do it's thang
	
	;=================================================================
	;-------------------------------------- Setup the SFX Sample bank
	;=================================================================
	
	.EXTERN U235SE_ptr_sample_bank
	lea		U235SE_ptr_sample_bank,a0	; address of the sample bank pointer in the SoundEngine
	move.l	#sample_bank,(a0)			; store the address of where the bank is in the pointer
	
	.EXTERN U235SE_playmod			
	move.l	#1,U235SE_playmod				; Enable mod playback

;================================================================================================================ MAIN LOOP
mainloop:

	jsr			readpad1		; poll joypad
	
.wait:
	cmpi.w	#1,VBIFLAG			; Has a VBI occured?
	bne		.wait				; nope
	clr.w	VBIFLAG				; yep, clear the flag and run the main loop again
	
	bra.s	mainloop

.EXTERN U235SE_sfxplaylist_ptr

;========================================================================================================== JAGPAD ROUTINE

readpad1:
	move.l	U235SE_pad1,d0		; Read the current button status of pad 1 into d0
	
	btst	#U235SE_BBUT_1,d0	; Test for the button presses we are interested in and branch appropriately
	bne.s	pad1
	btst	#U235SE_BBUT_2,d0
	bne.s	pad2
	btst	#U235SE_BBUT_3,d0
	bne.s	pad3
	btst	#U235SE_BBUT_4,d0
	bne.s	pad4
	btst	#U235SE_BBUT_5,d0
	bne		pad5
	btst	#U235SE_BBUT_6,d0
	bne		pad6
	btst	#U235SE_BBUT_7,d0
	bne		pad7

	rts

;======================================================================================================== JAGPAD FUNCTIONS
	
;------------------------------------------------------------------------------------------------------------------- PAD 1
pad1:
	move.l	#U235SE_NOMOD,U235SE_playmod		; setting playmod to 0 will stop module playback
	rts

;------------------------------------------------------------------------------------------------------------------- PAD 2	
		
pad2:
	move.l	#U235SE_PLAYMONO,U235SE_playmod		; Setting playmod to anything other than zero will start module playback
	rts

;------------------------------------------------------------------------------------------------------------------- PAD 3	
	
pad3:
	movem.l	d0/a0-a1,-(sp)
	lea		playlist,a0			; The address of the sound effect playlist
	lea		U235SE_sfxplaylist_ptr,a1

	move.l 	#sample_bank,d0 	; Put address of sample bank in d0
	and.l 	#$fffffff0,d0 		; mask off the low nibble
	or.l 	#$b,d0 				; add Set Sample Bank instruction
	move.l 	d0,(a0)+ 			; Write Set bank to playlist
	
	; This is command #4 - play sample at frequency
	; Commands are 32 bit words made up typically of YYYYXXVC
	; YYYY = Data for command
	; XX   = Data for command
	; V    = Voice to act on
	; C    = Command number
	
	move.l	#$1f400004,(a0)+	; play sample 0 on voice #0 at frequency 8000Hz
	
	; The above breaks down as follows:
	; $1f400004
	;  YYYYXXVC
	;
	; YYYY = $1f40 = 8000 .. in this case the sample frequency in Hz
	; XX   = $00   = 0  .. Sample number 0, so the 1st sample from sample bank
	; V    = $0    = 0  .. Voice number 0, the 1st voice
	; C    = $4    = 4  .. Command 4, play sample at specified frequency
	
	move.l	#0,(a0)				; terminate the end of the list - Or the SE will skip off through RAM making a mess
	
	move.l	#playlist,d0		; once the list is complete, we need to set the playlist pointer to point at it
	move.l	d0,(a1)				; As soon as this is written the SE will start working through the list of commands
	movem.l	(sp)+,d0/a0-a1
	rts

;------------------------------------------------------------------------------------------------------------------- PAD 4	
	
pad4:
	movem.l	d0/a0-a1,-(sp)
	lea		playlist,a0
	lea		U235SE_sfxplaylist_ptr,a1

	move.l 	#sample_bank,d0 	; Put address of sample bank in d0
	and.l 	#$fffffff0,d0 		; mask off the low nibble
	or.l 	#$b,d0 				; add Set Sample Bank instruction
	move.l 	d0,(a0)+ 			; Write Set bank to playlist	
	
	move.l	#$00000012,(a0)+	; play sample 0 at it's default frequency as defined in the sample bank on voice 1

	move.l	#0,(a0)
	
	move.l	#playlist,d0
	move.l	d0,(a1)
	movem.l	(sp)+,d0/a0-a1
	rts
	
;------------------------------------------------------------------------------------------------------------------- PAD 5		
	
pad5:
	movem.l	d0/a0-a1,-(sp)
	lea		playlist,a0
	lea		U235SE_sfxplaylist_ptr,a1

	move.l 	#sample_bank,d0 	; Put address of sample bank in d0
	and.l 	#$fffffff0,d0 		; mask off the low nibble
	or.l 	#$b,d0 				; add Set Sample Bank instruction
	move.l 	d0,(a0)+ 			; Write Set bank to playlist	
	
	move.l	#$62,(a0)+			; Same as PAD 4 but voice #6 

	move.l	#0,(a0)
	
	move.l	#playlist,d0
	move.l	d0,(a1)
	movem.l	(sp)+,d0/a0-a1
	rts


;------------------------------------------------------------------------------------------------------------------- PAD 6		
	
pad6:
	movem.l	d0/a0-a1,-(sp)
	lea		playlist,a0
	lea		U235SE_sfxplaylist_ptr,a1

	move.l 	#sample_bank,d0 	; Put address of sample bank in d0
	and.l 	#$fffffff0,d0 		; mask off the low nibble
	or.l 	#$b,d0 				; add Set Sample Bank instruction
	move.l 	d0,(a0)+ 			; Write Set bank to playlist
	
	move.l	#$72,(a0)+
	
	move.l	#0,(a0)
	
	move.l	#playlist,d0
	move.l	d0,(a1)
	movem.l	(sp)+,d0/a0-a1
	rts

;------------------------------------------------------------------------------------------------------------------- PAD 7		
pad7:
	movem.l	d0/a0-a1,-(sp)
	lea		playlist,a0
	lea		U235SE_sfxplaylist_ptr,a1

	move.l 	#sample_bank,d0 	; Put address of sample bank in d0
	and.l 	#$fffffff0,d0 		; mask off the low nibble
	or.l 	#$b,d0 				; add Set Sample Bank instruction
	move.l 	d0,(a0)+ 			; Write Set bank to playlist	
	
	; play the sample on all 8 voices at the same time
	
	move.l	#$02,(a0)+
	move.l	#$12,(a0)+
	move.l	#$22,(a0)+
	move.l	#$32,(a0)+
	move.l	#$42,(a0)+
	move.l	#$52,(a0)+
	move.l	#$62,(a0)+
	move.l	#$72,(a0)+
	
	move.l	#0,(a0)
	
	move.l	#playlist,d0
	move.l	d0,(a1)
	movem.l	(sp)+,d0/a0-a1
	rts

;==================================================================================================================== INCLUDES	

.INCLUDE "setup.s"		; Jaguar setup routines
.INCLUDE "vbi.s"		; Vertical Blank setup / routines

;======================================================================================================================== DATA
.LONG	
playlist:	dc.l	0,0,0,0,0,0,0,0,0,0
	
oldpos:		dc.l	$ff

.DPHRASE
sample_bank:
	; Sample #1
		dc.l	sample1		; base address of sample in RAM
		dc.l	sample1_end	; End of sample
		dc.l	0			; RBASE
		dc.l	0			; REND
		dc.l	64			; <null word> | Fine tune | Volume
		dc.l	6000		; Default play frequency (only used in SFX)
							; 24 bytes per sample.  744 bytes total

;=========================================================================================================== Example Sample

sample1:
.INCBIN "orch.sam"
	
sample1_end:	dc.b	0
.EVEN

;=========================================================================================================== Example Module
.LONG
module:
.INCBIN "alf.mod"


		
		